/* --------------------------------------------------------------
  PreviewImageModal.js 2019-06-07
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/


'use strict';

import Modal from '../libs/Modal'; 
import EventsEmitter from '../libs/EventsEmitter';

/**
 * Upload Image Modal Controller
 *
 * This controller will handle the image upload. After a successful upload it will set the newest
 * image to the setting that triggered the upload and then it will also update the select boxes of
 * all the other image widgets, so that the option is also available there.
 */
export default class PreviewImageModal {
	/**
	 * Class Constructor 
	 * 
 	 * @param {jQuery} $target Select box selector of the setting that triggered the modal.
	 */
	constructor($target) {
		StyleEdit.Validator.isObject($target);
		
		/**
		 * Select Box
		 *
		 * @type {jQuery}
		 */
		this.$target = $target;
		
		/**
		 * The modal selector.
		 *
		 * @type {jQuery}
		 */
		this.$modal = null;
	}
	
	/**
	 * Initialize Controller
	 */
	initialize() {
		const data = {
			title_preview_image_modal: StyleEdit.Language.translate('title_preview_image_modal', 'style_edit'),
			image_url: StyleEdit.Config.get('previewUrl') + '/' + StyleEdit.Config.get('imagesDir')
			+ this.$target.find('option:selected').text()
		};
		
		this.$modal = Modal.show($('#preview-image-modal-template'), data);
		
		this.$modal.on('click', '.btn.ok', () => this.destroy());
		
		EventsEmitter.triggerControllerInitialized(this.$modal, ['PreviewImageModal']);
		
		$.material.init();
	}
	
	/**
	 * Destroy Controller
	 */
	destroy() {
		Modal.hide(this.$modal);
		EventsEmitter.triggerControllerDestroyed(this.$modal, ['PreviewImageModal']);
	}
}
